Version 1/171220 of Ailihphilia Tables by Andrew Schultz begins here.

volume big random table

[use dbh.py to generate debug table version of this file]
[use palver.py to verify palindromes]
[use dno.py to detect duplicates in notes]
[use duptab.py to weed out duplicates in the table file proper]

part the code

table-freeze is a truth state that varies.

to next-rand (t - a table name):
	let post-cycle-check be false;
	choose row with tabnam of t in table of all randoms;
	if table-name-show is true:
		say "<[t]>";
	if table-freeze is true:
		now table-freeze is false;
	else:
		increment tabidx entry;
	if tabidx entry > number of rows in tabnam entry:
		if debug-state is true, say "(Cycling--debug note) ";
		now tabidx entry is 1;
		if thru-yet entry is 0:
			now thru-yet entry is 1;
			now rand-cycle is true;
			now post-cycle-check is true;
	let Q be tabidx entry;
	let lb be lbrk entry;
	choose row Q in tabnam entry;
	say "[randtxt entry][if lb is true][line break][else][no line break][end if]";
	if post-cycle-check is true:
		if t is table of NPC mistakes:
			choose row with tabnam of t in table of all randoms;
			say "[line break][cycle-note entry][line break]";

table-name-show is a truth state that varies.

to say next-rand-txt of (t - a table name):
	next-rand t;

to say same-rand-txt of (t - a table name):
	now table-freeze is true;
	next-rand t;

to say last-in-loop: say "This is just a note that you've seen all the current command's random responses, and they'll loop after this. Thanks for poking around so much"

table of all randoms
tabnam	tabidx	thru-yet	lbrk	desc	cycle-note
table of altbooks	0	0	false	"extra books in the Relate Taler"	"You've read all the books on the Relate Taler. Well, except for [i]Lives As Evil[r]. You'll skip that one."
table of attackings	0	0	true	"responses to ATTACK"	"[last-in-loop]."
table of babel babble	0	0	false	"babbles if you LISTEN in Le Babel"	"The most horrid whisper of all is of the NRA Barn. Ghastly!"
table of bad places	0	0	false	"places beyond Yell Alley"	"That has to be the last one. Boy, all that seediness!"
table of Bond Nob bars	0	0	false	"bars the Bond Nob visits"	"Your head reels from everywhere the Bond Nob's been."
table of burnies	0	0	true	"responses to BURN"	"I'm all burned out of clever random responses now. Ha ha."
table of businesses	0	0	false	"businesses in Day-Away Ad"	"... and wait! There'll even be a new Deft Fed, owned by a salt-of-the-earth type named Treffert, now that Sniffins/Smuggums totally sold out!"
table of diktat taunts	0	0	false	"Diktat Kid taunts"	"'BOSS SOB!' the Diktat Kid yells, finally free from the shackles of political correctness."
table of King Nik ancestors	0	0	false	"King Nik ancestors (TALK to King Nik)"	"So much to live up to for King Nik. Listening's good, but maybe you can take action."
table of machines	0	0	false	"machines in Work Row post-test set"	"You stop and think a moment. None of those machines were as useful as the original three."
table of Moo Room animals	0	0	false	"Moo Room animals (LISTEN)"	"Finally, you hear a single ewe, which you're surprised you didn't hear earlier."
table of Ms Ism pals	0	0	false	"Ms Ism's pals (TALK to Ms Ism)"	"Whoah! She's had a lot to say, and she's going to say it again. Surely there must be a way to deal with her."
table of My Gym songs	0	0	false	"songs in My Gym (LISTEN)"	"The final tune as the set abates is surprisingly catchy: [i][']S ADIDAS[r]. As it fades, you also realize you heard nothing by ABBA! Low class, low class." [yes, Run-DMC's My Adidas]
table of noesies	0	0	true	"responses to NO"	"An epony-NOPE rings through your ears to push back against your negativity in grand fashion."
table of nothings	0	0	true	"responses to empty commands"	"[last-in-loop]."
table of npc mistakes	0	0	false	"CALL/PHONE random NPC text"	"That's all there is. You [if aid-LLP-yet is false]can't help wondering if there's something better to dial for help, or a hint, or something[else]find this all less fruitful than when you decided to DIAL AID[end if]."
table of political stuff	0	0	false	"political stuff in the ex-Red Roses Order"	"'Slo pols,' you muse to yourself, as the debates re-rage, only moving fractionally forward."
table of random authors	0	0	false	"random author names (ones I particularly liked)"	--
table of random palindrome firstlast names	0	0	false	"First/last names in Name ME Man"	"Impressive! You made it through the phone book."
table of random palindrome lastfirst names	0	0	false	"Last/first names in OH WHO"	"Impressive! You made it through the phone book."
table of rejected kid sidekicks	0	0	false	"the Diktat Kid's rejected kid sidekicks"	--
table of Rob droning	0	0	false	"things Rob babbles about"	"'Rod or Rog or Roy or Roz or ... rot.' Rob takes a moment to shape 'pahs' again."
table of sci pics subjects	0	0	false	"sci pics subjects"	"That's all the education the sci pics offer, but you can read again, if you want."
table of singstuff	0	0	true	"responses to SINGing"	"Won't be joining OctetCo with that voice."
table of snooty toon ads	0	0	false	"snooty toons ads"	"At the end is La Usual, because of course. Everything else is doofy food."
table of swearstuff	0	0	true	"responses to SWEARing"	"Okay, you've had enough attention, I hope. I'm out of shocked responses to your language."
table of trashy art	0	0	false	"other 'art' [if DWELT LEWD is off-stage]a book hidden in the Tract Cart[else]DWELT LEWD[end if] promotes"	"That's all. Your intellectual (I hope) curiosity sated, you look for more constructive tasks[lewd-true], not worried (again, I hope) you've forgotten the plot of DWELT LEWD by now."
table of undoings	0	0	true	"UNDOing notifications"	"[last-in-loop]."
table of university primary targets	0	0	false	"Dr. D/Code Doc's prospective titled colleagues"	"Well, that's the formal doctors repeating. Or starting to."
table of university secondary targets	0	0	false	"Dr. D/Code Doc's prospective untitled colleagues"	"And now the untitled colleagues are repeating. Still, it took a while. The Code Doc has big plans!"
table of waittxt	0	0	true	"responses to WAITing"	"[last-in-loop]."
table of wordy drow laments	0	0	false	"Wordy Drow laments"	"The Wordy Drow has an eternity to repeat itself, but you don't. What could you do to get past it and the liar grail?"
table of yall people	0	0	true	"Y'All Ay people (Toll Lot post-win)"	"Incidentally, there are a lot more, but I decided to restrict things. I mean, there were 2 megabytes of possibilities."
table of yessies	0	0	true	"responses to YES"	"[last-in-loop]."
table of yuge baits	0	0	false	"Yuge Guy bait if you run away"	"The Yuge Guy emits a side-dis you probably weren't meant to hear fully. can't quite hear, and you are enraged enough to want to go back and deal with him later."
table of yuge battle cries	0	0	false	"Yuge Guy battle cries"	"'Dad?! Dad!!! Dad?!' the Yuge Guy yells, in a mixture of rage and supplication. Geez, he's got some issues. Señor drones, you think you yourself, as he winds up for a repeat round of nonsense."

rand-cycle is a truth state that varies.

every turn (this is the notify cycling rule):
	if rand-cycle is true:
		let tn be a table-name;
		let tables-found be 0;
		now rand-cycle is false;
		repeat through table of all randoms:
			if thru-yet entry is 1:
				now thru-yet entry is 2;
				increment tables-found;
				if debug-state is true, say "DEBUG: will be cycling [tabnam entry].";
				if tables-found is 1:
					say "[line break][if there is a cycle-note entry][cycle-note entry][line break][else]Whoah...that sounds familiar. You suspect the dialogue will loop again.[end if]";
				else if tables-found is 2:
					say "This is a further note to say you've looped through random text more than once this turn, which is an impressive bit of timing, even if it doesn't get you any points.";
		if tables-found is 0 and debug-state is true, say "This is a BUG--you should have been notified of random cycling in a table, but you weren't.";
		the rule succeeds;

volume random names of people and places

chapter random names

[NOTE: can-m + can-f = a unisex name. False/False should never happen.]
table of random authors [xxauth]
randtxt	can-m	can-f
"Eliza Bazile"	false	true
"Imogene Gomi"	false	true
"Kera Marek"	false	true
"Leta Patel"	false	true
"Marge Pegram"	false	true
"Mika Hakim"	false	true
"Norma Damron"	false	true
"Reiko Kier"	false	true
"Rhea Baehr"	false	true
"Signe Kengis"	false	true
"Blake DeKalb"	true	true
"Corky Kroc"	true	true
"Leigh Giel"	true	true
"Adam Imada"	true	false
"Eldon Odle"	true	false
"Elias Osaile"	true	false
"Emory Rome"	true	false
"Gino Konig"	true	false
"Levi Rivel"	true	false
"Mark Cockram"	true	false
"Neil Klien"	true	false

table of random palindrome firstlast names [xxfirstname]
randtxt
"Abe Keba"
"Adam Amada"
"Adina Canida"
"Agnus Unga"
"Aida Madia"
"Ailene Lia"
"Al Ayala"
"Al Kukla"
"Alena Canela"
"Alena Panela"
"Ali Vila"
"Alie Keila"
"Alina Manila"
"Alisa Basila"
"Alona Zanola"
"Ami Cima"
"Ami Zima"
"Amy Ma"
"Ana Susana"
"Anibal Abina"
"Anika Kina"
"Anitra Martina"
"Annalee Lanna"
"Anne Kenna"
"Anne Senna"
"Annika Kinna"
"Anya Payna"
"Anya Rayna"
"Art Ra"
"Asa Casa"
"Ava Lava"
"Azalee Laza"
"Bernie Weinreb"
"Bert Streb"
"Betsey Esteb"
"Blake Kalb"
"Breana Erb"
"Breanna Erb"
"Bret Erb"
"Brett Erb"
"Bruce Curb"
"Burt Strub"
"Cami Mac"
"Cara Sarac"
"Cassie Issac"
"Daisy Siad"
"Dara Jarad"
"Dee Reed"
"Denese Ned"
"Dia Zaid"
"Dian Aid"
"Diann Aid"
"Dick Cid"
"Dorene Rod"
"Dori Girod"
"Dorla Walrod"
"Duane Naud"
"Duane Renaud"
"Ed Larralde"
"Ed Lazalde"
"Eda Wade"
"Edie Weide"
"Edna Lalande"
"Edna Lande"
"Edna Sande"
"Edra Garde"
"Edy Hyde"
"Eero Goree"
"Ela Bale"
"Ela Cicale"
"Ela Dale"
"Ela Yale"
"Elana Canale"
"Elba Zable"
"Elda Wadle"
"Eli Hile"
"Eli Kile"
"Elia Haile"
"Elida Nadile"
"Elisa Basile"
"Ella Malle"
"Ella Valle"
"Ellena Fanelle"
"Elli Hille"
"Elli Tille"
"Elly Hylle"
"Elsi Aisle"
"Elsie Isle"
"Elva Mavle"
"Ely Pyle"
"Elza Hazle"
"Emiko Kime"
"Emil Glime"
"Emily Lime"
"Emma Hamme"
"Emma Lamme"
"Emmett Temme"
"Emmitt Imme"
"Emmitt Timme"
"Emogene Gome"
"Ena Lane"
"Ena Sayasane"
"Ena Zane"
"Enoch Cone"
"Enola Malone"
"Enola Valone"
"Eric Scire"
"Erma Hamre"
"Essie Heisse"
"Essie Weisse"
"Estelle Tse"
"Etta Matte"
"Eugene Gue"
"Eura Larue"
"Eva Dave"
"Eve Leve"
"Evo Love"
"Ewa Hawe"
"Ezra Marze"
"Fae Leaf"
"Flo Rolf"
"Flo Wolf"
"Flora Marolf"
"Florene Rolf"
"Gia Haig"
"Gil Lellig"
"Gina Hanig"
"Gino Honig"
"Gio Doig"
"Gitte Rettig"
"Glenn Elg"
"Hal Olah"
"Hanna Vannah"
"Harold Lorah"
"Helene Leh"
"Herb Reh"
"Hoyt Yoh"
"Ike Ueki"
"Ila Bali"
"Ila Cali"
"Ilana Li"
"Ileana Eli"
"Ilene Li"
"Illa Valli"
"Ilona Noli"
"Ima Kawakami"
"Ina Kakani"
"Inga Bagni"
"Inga Magni"
"Inga Pagni"
"Inga Papagni"
"Iola Kaloi"
"Iola Loi"
"Iona Manoi"
"Ira Bari"
"Ira Gari"
"Irena Neri"
"Irene Neri"
"Irene Veneri"
"Iva Ravi"
"Jade Dedaj"
"Jame Maj"
"Jamee Maj"
"Jani Kinaj"
"Ka Dudak"
"Kai Ziak"
"Kai Zuziak"
"Kala Balak"
"Kali Milak"
"Kamala Mak"
"Kami Kimak"
"Kami Mak"
"Kara Barak"
"Kari Jirak"
"Karisa Sirak"
"Karl Rak"
"Kate Betak"
"Kate Tak"
"Katy Tak"
"Kay Babyak"
"Kaye Deyak"
"Keely Leek"
"Keira Riek"
"Keli Bilek"
"Keli Cilek"
"Keli Lek"
"Kelle Sellek"
"Ken Okonek"
"Kena Danek"
"Kena Janek"
"Kena Vanek"
"Kena Yanek"
"Kera Zarek"
"Keri Sirek"
"Keva Pavek"
"Kia Haik"
"Kiana Naik"
"Kim Adamik"
"Kina Panik"
"King Nik"
"Kyla Halyk"
"Kyra Caryk"
"Lacy Cal"
"Lael Cleal"
"Lala Kalal"
"Lana Canal"
"Lani Pinal"
"Lara Baral"
"Lavelle Val"
"Lavette Val"
"Lawanna Wal"
"Leda Fadel"
"Leda Nadel"
"Lee Keel"
"Lee McMeel"
"Lee Neel"
"Lee Peel"
"Leena Neel"
"Lem Azamel"
"Lenna Kannel"
"Leo Joel"
"Leona Noel"
"Leora Roel"
"Lera Karel"
"Les Sissel"
"Lesa Basel"
"Lesia Maisel"
"Lessie Geissel"
"Levi Kivel"
"Lex Axel"
"Lia Gail"
"Liam Smail"
"Liana Nail"
"Liane Nail"
"Liberty Trebil"
"Lien Oneil"
"Lila Kalil"
"Lisa Basil"
"Lisa Vasil"
"Lise Sil"
"Lisette Sil"
"Lissa Bassil"
"Lissa Vassil"
"Lita Patil"
"Liza Bazil"
"Lona Nol"
"Long Nol"
"Loni Nol"
"Lora Carol"
"Lory Tyrol"
"Love Devol"
"Lu Aul"
"Luann Aul"
"Luna Canul"
"Ma Eleam"
"Mamie Imam"
"Marcene Cram"
"Marci Cram"
"Marco Cram"
"Marcy Cram"
"Margene Gram"
"Margo Gram"
"Margot Ogram"
"Mari Ram"
"Maria Bairam"
"Mark Akram"
"Marta Tram"
"Marty Tram"
"Marv Avram"
"Mary Byram"
"Matt Tam"
"Maya Rayam"
"Maybelle Byam"
"Mel Klem"
"Melba Blem"
"Mia Baim"
"Mika Kim"
"Mike Kim"
"Miko Kim"
"Mila Lim"
"Milo Lim"
"Mina Ganim"
"Mina Nim"
"Ming Nim"
"Minh Nim"
"Mira Karim"
"Mirta Trim"
"Miyoko Yim"
"Na Gahagan"
"Na Gilligan"
"Na Henehan"
"Na Holohan"
"Na Noonan"
"Na Susan"
"Naida Hadian"
"Nam Dudman"
"Nan Onan"
"Nana Kanan"
"Naomi Moan"
"Nate Tan"
"Ned Aden"
"Ned Dudden"
"Ned Eden"
"Ned Oden"
"Ned Rarden"
"Neda Baden"
"Neda Haden"
"Neda Vaden"
"Nedgor Ogden"
"Nedra Darden"
"Nedra Varden"
"Neely Leen"
"Neida Dien"
"Nella Gallen"
"Nella Mallen"
"Nelle McMellen"
"Nelle Yellen"
"Neoma Moen"
"Neomi Moen"
"Neta Paten"
"Nettie Leitten"
"Neva Daven"
"Nevada Daven"
"Nia Cain"
"Nia Fain"
"Nia McMain"
"Nia Pain"
"Nida Jadin"
"Nida Sadin"
"Nigel Klegin"
"Niki Aikin"
"Niki Kin"
"Nila Balin"
"Nila Palin"
"Nilda Gadlin"
"Nilsa Caslin"
"Nilsa Gaslin"
"Nilsa Maslin"
"Nina Ganin"
"Nina Susanin"
"Nino Bonin"
"Nita Matin"
"Nita Patin"
"Noe Leon"
"Noemi Simeon"
"Nola Salon"
"Noma Damon"
"Noma Ramon"
"Nona Manon"
"Nora Aaron"
"Nora Baron"
"Nora Daron"
"Nora Maron"
"Norah Aharon"
"Norah Aron"
"Norah Charon"
"Norah Sharon"
"Norene Ron"
"Nova Lavon"
"Nyla Lyn"
"Oda Bado"
"Odell Ledo"
"Odile Lido"
"Ola Salo"
"Olene Lo"
"Ollie Aeillo"
"Oma Didamo"
"Omar Amo"
"Omer Emo"
"Omer Gremo"
"Ona Kano"
"Ona Llano"
"Onie Reino"
"Onita Catino"
"Onita Patino"
"Onita Tino"
"Opal Apo"
"Ora Caro"
"Ora Faro"
"Ora Paparo"
"Oralee Laro"
"Oren Ero"
"Otis Ito"
"Otto Dotto"
"Ozell Lezo"
"Pa Yap"
"Rae Gear"
"Raelene Lear"
"Raina Maniar"
"Ramiro Rimar"
"Ramon Omar"
"Ramu Kumar"
"Ray Dyar"
"Rea Baer"
"Reba Faber"
"Reba Jaber"
"Reda Mader"
"Reda Nader"
"Reda Sader"
"Reena Neer"
"Regan Ager"
"Regina Niger"
"Regina Saniger"
"Regine Weniger"
"Reina Lanier"
"Reina Manier"
"Reita Matier"
"Rema Hamer"
"Rema Kamer"
"Ren Hohner"
"Rena Haner"
"Rena Waner"
"Renae Beaner"
"Renae Deaner"
"Renda Ladner"
"Rene Gener"
"Renea Haener"
"Renee Deener"
"Renita Tiner"
"Renna Banner"
"Renna Danner"
"Renna Tanner"
"Renni Winner"
"Ressie Heisser"
"Ressie Weisser"
"Reta Sater"
"Reta Yater"
"Retta Satter"
"Reva Baver"
"Reva Haver"
"Rey Byer"
"Rey Dyer"
"Rey Iyer"
"Rhea Ehr"
"Rheba Behr"
"Ria Fair"
"Ria Mair"
"Rima Jamir"
"Risa Nasir"
"Rita Satir"
"Riza Nazir"
"Riza Wazir"
"Rod Amador"
"Rod Odor"
"Roger Gregor"
"Rolf Lor"
"Roman Amor"
"Romana Mor" [okdup]
"Ron Oconor"
"Rona Manor"
"Roni Minor"
"Rosana Sor"
"Rosanna Sor"
"Rose Sor"
"Roselle Sor"
"Rosita Tisor"
"Ross Sor"
"Rosy Sor"
"Rosy Tysor"
"Rubi Bur"
"Ruby Bur"
"Russ Sur"
"Ruth Tur"
"Ryan Ayr"
"Sade Das"
"Sal Blas"
"Samara Mas"
"Sana Llanas"
"Sara Taras"
"Sarah Dharas"
"Sari Miras"
"Sari Ras"
"Selena Caneles"
"Selina Niles"
"Sena Vanes"
"Setsuko Kustes"
"Shawanna Wahs"
"Shawn Wahs"
"Sher Drehs"
"Si Dodis"
"Si Tatis"
"Sid Edis"
"Sid Odis" [okdup]
"Silla Wallis"
"Sim Amis"
"Sim Aramis"
"Sima Damis"
"Sina McManis"
"Sirena Neris"
"Sol Abalos"
"Sol Avalos"
"Sol Peplos"
"Sona Danos"
"Sona Llanos"
"Soraya Ros"
"Stu Luts"
"Su Titus"
"Sue Reus"
"Sy Pepys"
"Tama Kamat"
"Tara Marat"
"Telma Hamlet"
"Tena Banet"
"Tena Llanet"
"Tera Jaret"
"Tera Maret"
"Tera Naret"
"Terra Barret"
"Terra Garret"
"Terra Jarret"
"Terresa Serret"
"Tessa Basset"
"Tessa Rasset"
"Tia Hait"
"Tia Tait"
"Tim Smit"
"Toni Minot"
"Toya Bayot"
"Tracee Cart"
"Traci Picart"
"Tracy Cart"
"Trena Vanert"
"Tressa Gassert"
"Tressie Weissert"
"Treva Ravert"
"Troy Ort"
"Ty O'Hoyt"
"Ulf Lu"
"Ulissi Lu"
"Wade Daw"
"Walt Law"
"Wei Liew"
"Yetta Battey"
"Yetta Mattey"
"Yevette Vey"
"Yoko Koy"
"Yuki Kuy"
"Zaida Diaz"
"Zella Callez"
"Zena Llanez"
"Zita Batiz"
"Zoe Oz"
"Zora Varoz"
"Zula Luz"

table of random palindrome lastfirst names [xxlastname]
randtxt
"Adelizzi, Leda"
"Adels, Leda"
"Ader, Freda"
"Adle, Zelda"
"Adler, Elda"
"Adling, Nilda"
"Adner, Brenda"
"Adney, Enda"
"Ady, Lyda"
"Agle, Helga"
"Ahsan, Asha"
"Ahsing, Nisha"
"Aikins, Nikia"
"Ailes, Elia"
"Airola, Loria"
"Akima, Tamika"
"Alesi, Gisela"
"Ali, Cecila"
"Ali, Lila"
"Ali, Mila"
"Alice, Cecila"
"Alimo, Mila"
"Aline, Nila"
"Allen, Ella"
"Alley, Ella"
"Aloisi, Ola"
"Amell, Ema"
"Amill, Ima"
"Amis, Ima"
"Ammer, Emma"
"Amonette, Noma"
"Amons, Noma"
"Amoroso, Roma"
"Amory, Roma"
"Anand, Nana"
"Anast, Sana"
"Anawalt, Lawana"
"Anawaty, Tawana"
"Andel, Edna"
"Ander, Edna"
"Andes, Edna"
"Anelli, Willena"
"Anes, Ena"
"Anesi, Sena"
"Anez, Ena"
"Anidi, Dina"
"Anis, Ina"
"Arai, Kiara"
"Arakawa, Kara"
"Araki, Kara"
"Aramini, Mara"
"Arata, Tara"
"Arato, Tara"
"Ard, Isidra"
"Arden, Edra"
"Ardis, Isidra"
"Arevalo, Lavera"
"Ariaza, Ira"
"Arico, Cira"
"Arie, Keira"
"Arif, Ira"
"Arimoto, Mira"
"Aris, Ira"
"Armato, Tamra"
"Aroca, Cora"
"Aron, Elenora"
"Arond, Nora"
"Arone, Nora"
"Arons, Nora"
"Asif, Isa"
"Aslett, Elsa"
"Asley, Elsa"
"Ater, Greta"
"Aveni, Neva"
"Avenoso, Neva"
"Aver, Treva"
"Averette, Reva"
"Avery, Reva"
"Avie, Iva"
"Avis, Iva"
"Axel, Alexa"
"Bede, Deb"
"Bela, Caleb"
"Borg, Rob"
"Brehm, Herb"
"Camara, Mac"
"Camilli, Mac"
"Cardozo, Drac"
"Cassio, Issac"
"Darby, Brad"
"Datz, Tad"
"Deere, Reed"
"Deneen, Ed"
"Deneke, Ned"
"Deng, Ned"
"Depp, Ed"
"Diaz, Zaid"
"Dora, Jarod"
"Dorf, Rod"
"Dorff, Rod"
"Dorn, Rod"
"Dornan, Rod"
"Dornon, Rod"
"Dotolo, Tod"
"Drane, Lenard"
"Dua, Maud"
"Earl, Rae"
"Earp, Rae"
"Edie, Heide"
"Edu, Jude"
"Eid, Edie"
"Eisler, Elsie"
"Eisley, Elsie"
"Ekin, Ike"
"Eli, Cecile"
"Elia, Maile"
"Elleby, Belle"
"Ellena, Janelle"
"Ely, Kyle"
"Emore, Jerome"
"Eron, Elenore"
"Esler, Else"
"Etter, Everette"
"Gramm, Marg"
"Grams, Marg"
"Guo, Doug"
"Halik, Akilah"
"Halima, Kamilah"
"Hano, Jonah"
"Haro, Norah"
"Hnat, Anh"
"Hsi, Tish"
"Iburg, Rubi"
"Ilse, Lesli"
"Iman, Ami"
"Imoto, Tomi"
"Issacs, Cassi"
"Isuzu, Si"
"Koor, Brook"
"Kral, Clark"
"Kramm, Mark"
"Lahr, Hal"
"Lama, Jamal"
"Laman, Amal"
"Lamar, Amal"
"Lamarr, Amal"
"Lamm, Al"
"Lanagan, Al"
"Laro, Coral"
"Larock, Coral"
"Laselle, Sal"
"Lau ,Al"
"LaValla, Val"
"LaVere, Val"
"Lavy, Val"
"Law, Al"
"Lea, Yael"
"Leban, Abel"
"Leban, Anabel"
"Ledo, Del"
"Lemelle, Mel"
"LeMere, Mel"
"Lena, Janel"
"Leone, Noel"
"Leonette, Noel"
"Leong, Noel"
"Lerra, Darrel"
"Leuga, Raguel"
"Levra, Marvel"
"Leza, Hazel"
"Li, Cecil"
"Li, Gil"
"Lieng, Neil"
"Lim, Emil"
"Llera, Darell"
"Lorr, Errol"
"Losada, Sol"
"Losh, Sol"
"Lua, Raul"
"Madan, Adam"
"Maday, Adam"
"Mahar, Graham"
"Mapp, Pam"
"Marban, Abram"
"Marcelle Cram"
"Mari, Hiram"
"Masaya, Sam"
"Mash, Sam"
"Mikasa, Kim"
"Mote, Tom"
"Mott, Tom"
"Muta, Tatum"
"Naidoo, Dian"
"Naidu, Dian"
"Naik, Ian"
"Naill, Ian"
"Nair, Brian"
"Naji, Jan"
"Nall, Ellan"
"Namur, Truman"
"Nau, Juan"
"Navarra, Van"
"Navin, Ivan"
"Nay, Ryan"
"Neel, Ileen"
"Nell, Allen"
"Neller, Ellen"
"Nero, Loren"
"Neve, Keven"
"Newell, Ewen"
"Niles, Elin"
"No, Son"
"Noda, Don"
"Noe, Deon"
"Noh, Shon"
"Nojiri, Jon"
"Nola, Lon"
"Noll, Lon"
"Nolt, Lon"
"Nord, Ron"
"Notley, Elton"
"Novel, Evon"
"Novell, Evon"
"Nuse, Sun"
"Nush, Sun"
"Nybo, Robyn"
"Obama, Bo" [ha ha ha no really it's the former White House dog]
"Okimoto, Tomiko"
"Ord, Isidro"
"Osawa, So"
"Ott, Otto"
"Pike, Kip"
"Rama, Jamar"
"Rama, Lamar"
"Rama, Tamar"
"Ramos, Omar"
"Rase, Cesar"
"Rebman, Amber"
"Reh, Cher"
"Remley, Elmer"
"Remo, Homer"
"Remos, Omer"
"Reys, Yer"
"Rial, Blair"
"Roh, Thor"
"Rolff, Flor"
"Rona, Eleanor"
"Rover, Trevor"
"Sailer, Elias"
"Salkind, Niklas"
"Sallade, Dallas"
"Samo, Tomas"
"Sano, Jonas"
"Sele, Les"
"Self, Les"
"Selz, Les"
"Seng, Agnes"
"Seniff, Ines"
"Sidor, Odis"
"Siller, Ellis"
"Sina, Janis"
"Sircy, Cris"
"Sirin, Iris"
"Sirko, Kris"
"Siu, Luis"
"Siva, Davis"
"Siva, Mavis"
"Sivak, Avis"
"Sival, Avis"
"Sivan, Avis"
"Sivley, Elvis"
"Soman, Amos"
"Su, Gus"
"Sugiki, Gus"
"Sung, Agnus"
"Tapaha, Pat"
"Tena, Janet"
"Todd, Dot"
"Trass, Art"
"Traut, Stuart"
"Truby, Burt"
"Truka, Kurt"
"Tyo, Hoyt" [okdup]
"Vereker, Ev"
"Yamada, May"
"Yeo, Joey"
"Yero, Corey"
"Yerty, Trey"
"Yore, Leroy"
"York, Roy"
"Yu, Guy"
"Zapata, Paz"
"Zill, Liz"

volume random responses

part the tables

[arranged alphabetically]

table of altbooks [xxbooks]
randtxt
"Admirer, I'm Da"
"Aegea"
"Ai, Lee Elia"
"Aiding Nidia"
"Ail, Glia"
"Allay Alla"
"Alluded Ulla"
"Am I, Ma"
"Ape Pa"
"Apollo, Pa"
"Ares's Era"
"Beware [']Er: a Web" [capsok]
"Bronze Sez Norb"
"Bruno [']N Urb"
"Career: a C" [capsok]
"Cindy, Syd, Nic"
"Cite Me TIC"
"Civil, I, Vic"
"Co-Data Doc"
"Curate Taruc"
"D'oh, Serene, Reshod"
"D'oh, Temp Method"
"Da Ennead"
"Dad, Dad"
"Dahl Had"
"Dale, Lad"
"Danae: an Ad" [capsok]
"Debuts Tubed"
"Deets, Teed"
"Denny [']N Ned"
"Desires Immiserised"
"Dew, Awed"
"Dew Onuses Unowed"
"Dew, Owed"
"DeWener, Renewed"
"Diademed Aid"
"Diagnosis On: G, Aid"
"Diapers, Repaid"
"Dib [']Nuff Unbid"
"Die, Rended Nereid"
"Dif, Firth Triffid"
"Dig Ruts? Turgid"
"Dim Anon Amid"
"Dip, Arc, Rapid"
"Dip, Ill Lipid"
"Dip Such, Cuspid"
"Do Banana Bod"
"Do Bozo Bod"
"Do Brewer Bod"
"Do Cede, Cod"
"Do Coo, Cod"
"Do, Gamma God"
"Do Pacific a Pod"
"Do Pay a Pod"
"Doll OD"
"Don Represser Pernod"
"Due Spy Pseud"
"Duo-Ladened Aloud"
"Eat, Roam, Aortae"
"Ebb, Acidic Abbe"
"Ebb, Error Rebbe"
"Ecarte Retrace"
"Edu [']Til, O, Solitude"
"EG Never's Revenge"
"Egoless Eloge"
"Elk City, Tickle"
"Emacs Came"
"Emoji, Jo, Me"
"Emu, Serene, Resume"
"Emulo-Volume"
"Eon Ace Canoe"
"Eponymy? Nope"
"Er, Old Lore"
"Era, Friar, Airfare"
"Era, War Aware"
"Era Was Aware"
"Era We Beware"
"Ere Hoodoo Here"
"Ere Manna, Mere"
"Ere Mojo Mere"
"Et Effete"
"Fan-izin['] AF" [capsok]
"Fer a Ref"
"Fit, O Motif"
"Flo D. Adolf"
"For a Jar Of"
"Ganymede, My Nag"
"Gardened Rag"
"GI, Big"
"Gnostic, It: Song"
"A Houdini Duo, Ha"
"Husks, Uh"
"I, a Rum, a Samurai"
"I, Lara Li"
"If I Had a Hi-Fi"
"IGTNT, GI" [capsok]
"In Mutual Autumn, I"
"Is Eli Miles I"
"It, Eye, Yeti"
"KC Attack"
"La, Pa, Papal"
"La, Pegasus Age Pal"
"Lab Inna Cannibal"
"Lad, Navy Vandal"
"Lay, O Royal"
"Les, Maddened Damsel"
"Lid Off a Daffodil"
"Lineker, Eke Nil"
"A Luau, La"
"Lug, O Mogul"
"M. Ulysses [']Sylum"
"Ma, Sam"
"Mad at Adam"
"Mafioso: I, Fam"
"A Malaga Lama"
"Mall Lam"
"Manikin? Am"
"A Mardy Drama"
"Me, Lo, Golem"
"Me, Log Golem"
"Miasms, Aim"
"Miss a Passim"
"Mo['] Idiom"
"Mo['] Idiom, Mo['] Idiom"
"Mo['] Neva['] Venom"
"Moi: Dig Idiom"
"Mop, Mop, Pompom"
"Mr. Owl Worm"
"Muses? Um"
"Mussolini: Loss, Um"
"Musts? Um"
"My Nonacidic Anonym"
"Nae Dyspepsy, Dean"
"Nae, Meds Demean"
"Nag Old Logan"
"Name: Garageman"
"Natively, Levitan"
"Needed, E'en" [capsok]
"Neil's Lien"
"Nemo's Omen"
"A Next Xena"
"Niece, In"
"No Cert Recon"
"No Dibs Bid On"
"No Eon: One? No, No Eon"
"No Gray Argon"
"No It-PM Exemption" [capsok]
"No Last Salon"
"No Moliere I, Lo, Mon"
"No Obsesses Boon"
"No Sad a Son"
"No Same Mason"
"Nod? No, London"
"Non-Ace Canon"
"Not Ruby Burton"
"Note Tons? No, Teton"
"Now Ere Rewon"
"NW Orb, Brown"
"O Bonobo"
"O, Had I Idaho"
"O Nary Cyrano"
"Odd-Eyed Do"
"Of Nil Info"
"Oksana's KO"
"On In, Nino"
"On, Nag, Anno"
"On Ropy Porno"
"Or Boohoo, Bro"
"Or Cleve Velcro"
"Or Terror Retro"
"Orc: A Macro"
"Orc: I'm Micro"
"Otter Amaretto"
"Pa, OAP"
"Pace, Recap"
"Pad Digresser, Giddap"
"Panama Nap"
"Pansy's Nap"
"Parses: Rap"
"A Pegasus Age, Pa"
"Pizazz: a ZIP" [capsok]
"Pocono Cop"
"Posada's Op"
"Prawn, Warp"
"Pretended Net, Erp"
"QB BBQ" [capsok]
"Rats, Popstar"
"Rawer Pre-War"
"Re: Gallager"
"Re: Karraker"
"Rec: Interpret Nicer"
"Recluse's Ulcer"
"Red Apse Spader"
"Red Doc, Odder"
"Red Loss, Older"
"Regress, Serger"
"Regular, a Luger"
"Relived Eviler"
"Ren, Old Loner"
"Report, Roper"
"Ret Same Master"
"Rev, I, Liver"
"Rev, Ol['] Plover"
"Rio Memoir"
"Rio Noir"
"Rise, Aesir"
"Risk Sir"
"A Rode Fedora"
"Rot, Corpses Proctor"
"Roy, a Mayor"
"S. Levin Snivels"
"Sag, Emo Omegas"
"Sage Vs. Vegas" [capsok]
"Saladin, I[']d, Alas"
"Sarge DeGras"
"Satire Veritas"
"See, Referees"
"Semi Times"
"Seminal Animes"
"Seres"
"Set-Age Gates"
"Set Interpret Nites"
"Sexism Sixes"
"Sexist Sixes"
"She Hoodoo-Hehs"
"Sir Ever Is"
"Sis Emend Nemesis"
"Sis Is"
"Six at Axis"
"Skee Geeks"
"Slade Pedals"
"Slay, O Royals"
"Slo-LOLs"
"Sly Dim Idyls"
"Snorting Ignitrons"
"So Ate Taos"
"So Bold Lobos"
"So Cede Decos"
"So, Ma, Vamos"
"So Pace Capos"
"Soil of Folios"
"Soppy Gyppos"
"Sore Duderos"
"Sore Heros"
"Sore Zeros"
"Sow Twos"
"Spacers['] Recaps"
"Specific EPs"
"Spoof: Oops"
"St. Sil, Cyclists"
"Stem, O Comets"
"Stress Asserts"
"Stutz Tuts"
"Sub Main Iambus"
"Sumac, Camus"
"Sun Off On Us" [capsok]
"Supremer P.U.'s"
"T-Rex, Exert"
"Tab Mock Combat"
"Talc, Eclat"
"Tasers Re-Sat"
"Ted, Ace Cadet"
"Tell a Wallet"
"Tie: Cede Deceit"
"Til Era Relit"
"Til Null Unlit"
"Til Psi Split"
"Til Purer Uplit"
"TIL Saga, Gaslit"
"To Banana Bot"
"To Bore Robot"
"To Bot"
"To Demand, Name Dot"
"To Grey Ergot"
"To Lips, Pilot"
"To Oldened Loot"
"To Pass a Pot"
"To Rate Tarot"
"To Tax a Tot"
"Too, Ms. Smoot"
"Torsos, ROT"
"Trail: I, Art"
"Train, I: Art"
"Tressa's Assert"
"Trope Report"
"Tuna, Epee, Peanut"
"Waikiki? Aw"
"Wakiki, [']K? Aw"
"We Degage Dew"
"We Few"
"We, Ivy View"
"Wedded Dew"
"Welsh Slew"
"Werewolf Flower? Ew"
"Won Snow"
"Wondered Now"
"X: a Minimax" [capsok]
"Yalp, Dr. O: Wordplay"
"Yaw, Dim Midway"
"Yes Mimsey"
"Yo Banana Boy"
"Yr Wry"
"Zot: A to Z"

table of attackings [xxatt]
randtxt
"D00d!"
"Dude! Dud."
"Fray! Arf!"
"Goon! Oog!"
"Harm! Rah!"
"Hood! Ooh!"
"Hun! Uh..."
"Hurt! Ruh!"
"Hut! Uh..."
"Knock! Conk!"
"Mal Slam!"
"Nae mean."
"No melee. lemon!"
"Pah! Whap?"
"Pal, SLAP?!"
"Po['] bop!"
"Pop!"
"Pow-op! Pow-op!"
"Regard, rager!"
"Spare raps!"
"Tiff. Fit."
"To ire! Riot!"
"Tonk? Not."
"Ye KO? Pokey!"
"Yob! Boy."

table of babel babble [xxbabel]
randtxt
"App A"
"Banana B"
"the Blub-Bulb"
"the BOFA Fob"
"the C-I Mimic"
"Da Doodad"
"the Day Dyad"
"Dresser D"
"E Garage"
"the Frac-Scarf"
"Gnomon G"
"the Gomorro-Mog"
"the Gulps-Plug"
"H Tooth"
"Hoodoo H" [okdup]
"the It-Cacti"
"Lotto L"
"Mojo M"
"Muumuu M"
"No-Mongo Gnomon"
"the Scoff-Focs"
"the Ton Knot"
"the Tsetses Test"
"Tso St"
"Vanillin Av"
"Vasts Av"
"the Were-W"
"Zoo Z"

table of bad places [xxcity] [xxplaces]
randtxt
"Acidica"
"Balling-Nil Lab"
"Dart-Strad"
"Dat-So-Stad"
"Dir-as-Arid"
"Drag-Gard"
"[']E-Rips-Spire"
"Gau Quag"
"Grub-Burg"
"Loopypool"
"Mire-Rim"
"Moory By-Room" [capsok]
"Nae-Cod Ocean"
"Neva-Haven"
"No-Trekker-Ton"
"Not-Civic-Ton"
"Not-Dud-Ton"
"Not-Kook-Ton"
"Noted-U=Rude-Ton"
"Par Terre-Trap"
"Rat Romp Mortar"
"Retchohcter"
"Rob-Rat Arbor"
"Rot-Cesses Sector"
"Rue Carte Traceur"
"Rue Craft-Farceur"
"Sediti-Tides"
"Siller-Trellis"
"Skeer-Creeks"
"Skrump Murks"
"Sliver-Evils"
"Sort-[']Em Metros"
"Spar-Traps"
"Speedy Deeps"
"the Stall-Ats" [capsok]
"Still-Lits"
"Swarm-Raws"
"Trop-Pap-Port"
"Y-Me'd Academy"
"Ya-Boo Bay"
"Yella['] Valley"

table of burnies [xxburn]
randtxt
"Burn! Rub!"
"Igniting, I!"
"Rah! Char!"
"Tiki kit?!"
"To hot?!"

table of Bond Nob bars [xxbar] [xxbond]
randtxt
"Bar Crab"
"Brewer B"
"Clan ALC"
"Clang'n Alc"
"Gong-Nog"
"Met [']Em"
"MRA Farm"
"Nigh Gin"
"Pat's Tap"
"Pink Nip"
"Potsy Stop"
"Pub UP"
"Redic-U-Cider"
"Safari Rafa's"
"Sage Vega's"
"Sal A'S"
"Sam A'S"
"Sara's"
"Sargent Negra's"
"Sassy Lyssa's"
"Scala C's"
"Scamp Mac's"
"Scene C's"
"Screwer C's"
"'Secrets' Terces"
"Senor One's"
"Senora Rone's"
"Set-Up Ute's"
"Shaka H's"
"Shakah's" [okdup]
"Shala H'S"
"Shanna H'S"
"Shara H'S"
"Shelleh's"
"Si Xi's"
"Si's"
"Sid I'S"
"Siggi's"
"Silent Neli's"
"Sip-a-Tap-Is"
"Slack Cal's"
"Smote Tom's"
"Soho's"
"Sordid Ro's"
"Soto's"
"Spate-Taps"
"Spike-Kip's"
"Spot's, Non-Stops"
"Steve T's"
"Struck Curt's"
"Su's"
"Susana-Su's"
"Tipsy Spit"
"Tope Depot"
"Vat Tav[']"
"Zara'z"
"Zorro'z"
"Zuzu'z"

table of businesses [xxbus] [xxbiz] [xxshop]
randtxt
"Art Sastra"
"Ate Beta"
"Ate By Beta" [capsok]
"Ate Feta"
"Baher's Rehab"
"Bill-Lib"
"Bruce[']s Use Curb"
"Burma Sam Rub"
"Castro-Ports AC"
"Colby Bloc"
"Color-Pro Loc"
"Dairy Myriad"
"Derby Bred"
"Detinue United"
"Diaper, Prepaid"
"Discs ID"
"Do-Mini-Mod"
"Dust-Sud"
"E-Vitative"
"El Ale"
"Era Ware"
"Eyre Rye"
"Goth Tog"
"Lager Ever Egal"
"Layaway Al"
"Le DO-Model"
"Le To-Hotel" [capsok]
"Let Race Cartel"
"Li Oil"
"Lit-Up Util"
"Llama Mall"
"Look Skool"
"Looks Skool"
"Med [']Em"
"Morocco Rom"
"MRI Firm"
"N-E-Gen"
"Oba Keeps Peekabo"
"OCDCo"
"Of Fobs Boffo"
"On-Is-Ace Casino"
"Or Fab Afro"
"Photo HP"
"Pot Stop"
"Potsdam Ad Stop"
"Rec Organa Grocer"
"Regal Lager" [okdup]
"Rep/Push Supper"
"Rife Kefir"
"Sabrer BA's"
"Saint Nia's"
"San Ana Bananas"
"Sci-Fi C's"
"Seller Elle's"
"Set-a-Dates"
"Set, Add Dates"
"Set Agates"
"Set-Arcana Crates"
"Shop O['] H's"
"Skooby Books"
"Sleepy-Peels"
"Slit-Up Utils"
"So Catharsis Rah Tacos"
"So Mild Limos"
"SockCos"
"Sog Rack Cargos"
"Sole Helos"
"Sorbo Bros"
"Spex Eps"
"Sporer Ops"
"Staffa T's"
"Steely Leets"
"Stella['] Ballets"
"Stella['] Wallets"
"Suede Us"
"Swen's News"
"TekCo Docket"
"Tider Credit"
"Toledo Node Lot"
"Tramp Mart"
"Tru-Go Yogurt"
"We, Serene, Re-Sew"
"We Sew"
"We, Snug, Unsew"
"We'd Lime Mildew"
"X U Tux"
"Xenon-Ex"
"Yost Soy"
"Yreka Bakery"

[this may be related to Yuge battle cries, but the Diktat Kid insults you. The Yuge Guy puffs himself up.]
table of diktat taunts [xxdiktat] [xxkid]
randtxt
"Ahahahahahaha!"
"At's-a BASTA!"
"Ax a..."
"Be EW, dweeb!"
"Collar? Alloc!"
"Cur! U C!"
"Da bad! Da BAD!! DA BAD!!!"
"Decide! Diced!"
"Decided: ICED!" [okdup]
"Dire! Rid!"
"Dude(tte)! Dud!"
"Duh, THUD!"
"El Bat-able!"
"Era: Perps Prepare!"
"Evil? I've..."
"Hah!"
"Human: Am, uh!"
"KO U! Ok?"
"Lepers! Repel!"
"LOLOLOLOL!"
"Looters! Re-tool!"
"Medicide'm!"
"Mess [']em!"
"Mix [']im!"
"Net foe, often!"
"Nil Merge, Gremlin!"
"No romp, moron!"
"Noogie! I, goon!"
"Noose soon!"
"Nutso! Stun!"
"Ok, TKO!"
"Ok to TKO!"
"Ooh, cad! Achoo!"
"Pansy! Snap!" [okdup]
"Peewee, weep!"
"Poorer! Oop!"
"Rah! Thar!"
"Resoldered loser!"
"ROFL! For..."
"Sir, Be Debris!"
"So mew, emos!"
"Sob-mock combos!"
"Sob, mudded dumbos."
"Tar! Boohoo, brat!"
"A tarred errata!"
"terror: ret!"
"To pot! To Pot!"
"Tot!"
"War? Aw...."
"War dagga[']: draw!"
"Ya Pay!"
"Yar! Ay!"
"Ye Bow, Obey!"
"ZAP, spaz!"

table of King Nik ancestors [xxnik]
randtxt
"Iolo I"
"Isaias I"
"Isis I"
"Ivana VI"
"Ivette VI"
"Ivy VI"
"Vi V"
"Vi XIV"
"Vic IV"
"Vikki V"
"Vin IV"
"Xene X"
"Xia IX"
"Xiara IX"
"Xiu IX"

table of machines [xxmachines]
randtxt
"re-deeder"
"re-life-filer"
"re-memer"
"re-peeper"
"re-reverer"
"re-toter"
"rec-anon-acer"
"rec artery retracer"
"recall lacer"
"recover-evocer"
"red ROFL forder"
"rekover-evoker"
"remanded namer"
"rotary gyrator"
"rotative levitator"
"roting ignitor"
"ruder-edu-r"

table of Moo Room animals [xxanimals]
randtxt
"an align-gila"
"any myna"
"a buck-cub"
"a cross orca"
"a deer, freed"
"an elk cackle"
"er, a hoodoo hare"
"er, a mare"
"flown wolf"
"a go-here hog"
"a go hog"
"a hen, eh"
"an I-OK koi"
"IO Koi"
"a klep-elk"
"a koala, ok"
"a lairage garial"
"a leet eel"
"a mark-ok ram"
"a mutt, um"
"naw-see swan"
"a neva['] raven"
"no ill lion"
"Pirana (RIP)"
"a pirana (RIP)"
"a PSA wasp"
"a pug nipping up"
"pupa pup"
"a rat avatar"
"a red darer adder"
"reedy deer"
"a rip-at tapir"
"a rum elk-lemur"
"sab mambas"
"sewed ewes"
"sewer ewes"
"ska yaks"
"smarm rams"
"smart rams"
"so-bonobos"
"so doddered dodos"
"so-dodos"
"so-OK cuckoos"
"so-uddered duos"
"sob mambos"
"sum emus"
"a tango gnat"
"a tarp sprat"
"a tart rat"
"an un-gnu"
"wasps, aw"
"a xerosis-o-rex"

table of My Gym songs [xxgym] [xxmy] [xxsong]
randtxt
"Age Mo['] Mega"
"Ai, Tia"
"Ail, Emelia"
"Air Aria"
"All Illa[']"
"[']Allo, Dolla[']"
"As I, Lisa"
"Bebe B"
"Belle B"
"Both to B"
"Da Ill-Iad"
"Darin['], I, RAD"
"Diana, I'd" [okdup]
"Diva David"
"Do Mo['] Mod"
"E-Babe"
"El Tootle"
"Emote to Me"
"Er, AWARE" [okdup]
"Ghosts, Oh, G"
"GI Gig"
"GI Jig"
"Goad a OG"
"Gots To, G"
"The H/T"
"H/T Fifth"
"H/T Ninth"
"H/T Nth" [capsok]
"Ha, Doo-Dah"
"Hat-Stah"
"Hollas All, Oh"
"Honk'n, Oh"
"Honor On, Oh"
"Hook, Ooh"
"Hosts, Oh"
"It is Ignitin['], G: Is It I?" [puncok] [capsok]
"Jenine J"
"Jesse J"
"Jimmi J"
"Jog, OJ"
"Jojo J"
"Khalilah K"
"Kiki K"
"Koko K"
"Krew Twerk"
"LA's Reversal"
"Lana L"
"Lay, Oldened Loyal"
"Le BE Rebel"
"LFO ROFL" [capsok]
"Lit Null Until"
"Lob My Symbol"
"Lulu L"
"M I Dim"
"M I Him"
"Major O['] JAM"
"Major Pro Jam"
"Manic in AM"
"Maybe By AM" [capsok]
"Me: Opt, Poem"
"Miami, Maim"
"Miff [']Im"
"Mikki M"
"Miss [']Im"
"Morph Prom"
"Mug [']Um"
"Muh Chum"
"No, Hon"
"No Mo['] Po['], Mon"
"No One Noon"
"No Orcs Croon"
"No Purer Upon"
"Nose Me, Son"
"O, Got to Go"
"O/T: Teh Ghetto"
"Ode: Dude, DO"
"Opera Repo"
"Or BE, Bro"
"Own W/O"
"Pard Rap"
"Park Rap"
"Petite P"
"Playa LP"
"Plaza LP"
"Plebe LP"
"Plus-U LP"
"Po['] Pop"
"Pump [']M Up"
"Punk'N Up"
"Rap Spar"
"Reno Loner"
"Rep More, Romper"
"Rev [']Er"
"Rev [']Er Ever"
"Rikki R"
"See Lee's"
"Set-a-Mates"
"Sex Imp Mixes"
"A Six Is a Six Is A"
"Sled O['] Yodels"
"So-BS ASBOS" [capsok]
"So Here Hos"
"So Lost Solos"
"SOBs['] ASBOs" [okdup]
"Solo Yolos"
"Spar Raps"
"Spark Raps"
"Stan-Ats"
"Sum Us"
"Sun Is in Us"
"Sun on Us"
"Tae Beat"
"Tae Heat"
"Tha H/T"
"Theme, H/T"
"There, H/T"
"These, H/T"
"Thoro['] H/T"
"Thy H/T"
"Tia, Wait"
"[']Tis Igniting, Is It"
"To Dot"
"To Hos So Hot"
"To Own: WOOT"
"To Sap a Sot"
"Too Fab Afoot"
"[']Vette V"
"Via IV"
"Wanna W"
"We Nab Anew"
"Woo Hoo W/"
"Y'All, Ay"
"Y'So Rosy"
"Y/N Oh Po['] Cacophony"
"Ya-Do Day"
"Yen O['] Money"
"Yet a Matey"
"Yo, Beer Free, Boy"
"A Yoga: Go, Ya"
"YOLO'y"
"Yr. Every"

table of noesies [xxno]
randtxt
"Dash sad."
"Derided! Ired!"
"Doomy mood?"
"Elim-Smile!"
"Emo, me."
"EVAR Grave?"
"Fretter? F!"
"Gen-U-Neg!"
"Ha! Bah!"
"Ha! Nah."
"Had a sad, ah!"
"Hm. SMH."
"Huh-uh."
"Moody? Doom!"
"No way? Aw, ON!"
"Nuh-uh-un[']!"
"One no."
"Oo! Noo!"
"Poor droop."
"Shoo, 'Pooh's." [aposok]
"To NOT!"
"Too 'boohoo?' Boot!"
"Wah? Thaw!"
"Wan? Aw."
"Woe meow."
"Ye po['] mopey!"
"Ye Po['] Nopey."
"Yes/rah? Arsey!"

table of nothings [xxblank]
randtxt
"Drown, word!"
"Dud!"
"Eh, the..."
"Gag?! Nuff! Ungag!"
"Hey! Eh?"
"Huh?"
"It? Nah, anti."
"La! Minimal!"
"Lapses, pal?"
"Line? Nil."
"Meh. Ahem!"
"Minim..."
"Mum?"
"No peep on?"
"Oi, Dio!"
"One mime? NO!"
"Peep?!"
"POST, sop!"
"Re-mimer!"
"Set, umm, mutes."
"Spill, lips!"
"Too moot."
"Verb! Rev!"
"Ya, no! Nay!"
"Yep, a gapey..."
"Yo! Coy?"

table of npc mistakes [xxnpc] [xxtalk]
randtxt
"Allo? Holla[']!"
"Da Sad!"
"Guv, ug!"
"Ha. Boo. Bah!"
"Hex, Eh?"
"I, Ha, ... Hi!"
"Oldened, Lo!"
"Orate? Tar, o!"
"Plead: a [']elp!"
"Rag us, sugar?"
"Rep [']er!"
"Sub us! Sub us!"
"Suss us!"
"Sux, us!"
"[']Tis it!"
"We mew!"

table of Ms Ism pals [xxism] [xxms]
randtxt
"Able Melba"
"Aglow Olga"
"AI Mia"
"AI Pia"
"AI Zia"
"Akin Anika"
"'Alerts' Estrela"
"Alleging Nigella"
"Ally Dylla"
"Amiss Ima"
"Ammo Momma"
"Anigh Gina"
"Anno-Donna"
"Anya-Dayna"
"Avid Iva"
"Ayn-Anya"
"Di Vivid"
"Diva X, Avid"
"Eel Annalee"
"Eel Azalee"
"Elegant Nagele"
"Even Eve"
"Frau Arf"
"Gemini Meg"
"Grammam Marg"
"Hammered-er Emma H" [capsok]
"Iller Elli"
"Irate Tari"
"'Ire' Geri"
"'Ire' Keri"
"'Ire' Teri"
"Janelle [']N AJ"
"Kym TMYK"
"Lava Val"
"Liv EVIL"
"'Lyre' Beryl"
"Maeve A.M." [puncok]
"Nedra, Warden"
"New Gwen"
"Ol['] Flo"
"Ordered Ro"
"Refine Jenifer"
"Su 'Tinnitus'"
"Tacy Cat"
"USA Su"
"Vile Liv"
"Xanadu Dana X"
"Yenta Oatney"
"Yvette-Vy"
"Zen Inez"
"Zulu Luz"

table of political stuff [xxpolitical] [xxpols]
randtxt
"an animals['] lamina"
"College L Loc"
"desks-ed"
"'Era flew: Welfare?!'"
"Livesse-Vil"
"Lo! Hol[']!"
"meets-esteem"
"the Met System"
"no-losses solon"
"'Noo! Bad! A boon?'"
"'of feds? Deffo'"
"Process E Corp"
"'Re-file, lifer'"
"'Rep met a temper!'"
"a repping nipper"
"'Rise to vote, Sir!'"
"'Sen., ozones?!'"
"set agent negates"
"set also slates"
"set art rates"
"set indexed nites"
"set overs, revotes"
"set upside disputes"
"sham ahs"
"shot ohs"
"shut uhs"
"'sit: nay, antis'"
"slope pols"
"so many dynamos"
"tae solo seat"
"the Teem-Civic Meet"
"Vogue-U-Gov"
"'Weed? Eew!'"
"'Yep, ey?'"
"'YMCA, Mac! My!'"

table of rejected kid sidekicks [xxsid] [xxrej] [xxbad]
randtxt
"Abler Elba"
"Accorded Rocca"
"ACDC A" [capsok]
"Ada Cicada"
"ADHD A" [capsok]
"Ailey Elia"
"AJ Ninja"
"Andy DNA"
"Anon A"
"Arid Ira"
"Arne NRA"
"'Aroma' Zamora"
"ASAP Asa"
"Asset Tessa"
"Awake Kawa"
"Balla['] B"
"Bama B"
"Bazza B"
"Best Seb"
"Blank'n Alb"
"Bloke Kolb"
"Blotto LB"
"Bobbo B"
"Boca Jacob"
"Boogles, El Goob"
"Booky Koob"
"Boyd Yob"
"Bozo B"
"Bronx Norb"
"Brony Norb"
"Bulgy Glub"
"Cement Nemec"
"Challah C"
"Crybaby RC"
"Der Fred"
"DETH Ted"
"'Die' Reid"
"'Diss' Sid"
"Djinni JD"
"Doggo D"
"'Dragnet' Engard"
"Drone Nord"
"Dronin['] Ord"
"Dry Fyrd"
"Dubya-y Bud" [capsok]
"eBay Abe" [p]
"Eel Klee"
"Eelworm Rowlee"
"'Effort' Roffe"
"'Egresses' Serge"
"Emil Slime"
"Eric Ire"
"Etna Dante"
"Evan Knave"
"Evil Clive"
"Flak Alf"
"Flan Alf"
"Flat Alf"
"Flax Alf"
"Fretster F"
"G-Nixing"
"Gaga G"
"gayo, voyager"
"Gazza G"
"'Gimme' Hemmig"
"Glass Alg"
"Gnaw (ha) Hwang" [capsok]
"'Gnaw' Hwang"
"'Gnaw' Kwang"
"Gnawy Wang"
"Goniffin['] Og"
"'Gorses' Rog"
"Gory Rog"
"Guru G"
"Gyppy G"
"Hal, Lot Ayatollah"
"Hamma['] H"
"Hat Ptah"
"Hobo H"
"Icy Ci"
"Jaded AJ"
"'Jazz' AJ"
"Jefe J"
"'Jests' EJ"
"Kazoo Zak"
"Kid-Daze Zaddik"
"Kimono Mik"
"Ladened Al"
"Lamin['] Animal"
"Lass Sal"
"Lax Al"
"Le Nolo-Colonel"
"Lebanon Abel"
"Led Adel"
"Lee, Hobo Heel"
"'Leer' Creel"
"Legal Slagel"
"Legit Igel"
"Lesser Tressel"
"'Lice' Cecil"
"Liven'd Nevil"
"Loco-Foco L"
"Loco L"
"Loopy Al Claypool"
"Lost Sol"
"Mad Adam"
"'Many' Bynam"
"Melee Lem"
"Melt-It Lem"
"Mildewed Lim"
"Mini-M" [ignore]
"Mofo M"
"'Motive' Vito M"
"'Mutton' Ottum"
"Namer Freman"
"Nappa N"
"Nash-San"
"Nasty Tsan"
"Navidad Ivan"
"Nay'r Bryan"
"Needy Deen"
"Nervy Vern"
"'Nets' Osten"
"New Owen"
"Newer Ewen"
"Nino Ronin"
"Nitro-Hortin"
"Noir Brion"
"Nolo Rolon"
"Nomad Damon"
"Norse's Ron"
"Nosier Eison"
"Nosy Tyson"
"Noter Breton"
"Obese Bo"
"'Obsesses' Bo"
"Ode-Lots Toledo"
"'Oedemas' Amedeo"
"Oily Lio"
"Okay Ayako"
"Okinawa Niko"
"Okra Marko"
"Ole Gnat Tangelo"
"Ole Putz Tupelo"
"Omaha Mo"
"Omen Emo"
"'On-Us' Tatsuno"
"'One' Geno"
"Osiris O"
"Otaku Kato"
"Ozzie Izzo"
"P. I. Kip"
"Peewee P"
"Perp Rep"
"Pete P"
"Potato P"
"Presser P"
"Raffa R"
"Raving Nivar"
"Recluse Sulcer" [okdup]
"Ref-Lord Rolfer"
"Reg Da Badger"
"Reg Nab-Anger"
"Reg Naff-Anger"
"Regal Slager"
"Regarded Rager"
"Reliant Nailer"
"Rely-Tyler"
"'Remarks' Kramer"
"Ren 'Rage' Garner"
"Ren Evilness-Enlivener"
"Ren Naff-Fanner"
"Ren Rube-Burner"
"Ren, Trapeze Partner"
"'Renege' Wegener"
"'Rental' Platner"
"Revel Clever"
"Rex, a Taxer"
"Rex, Axer"
"Rex, Indexed Nixer"
"Robbo R"
"Rocco R"
"Roger-Egor"
"Roja Major"
"Rollo R"
"Sage Degas"
"Sap Poppa S"
"Semi-Deified Imes"
"Semi-Hobo Himes"
"Senior Oines"
"Serg O['] Logres"
"Sim-All Amis"
"Sirrah Harris"
"solitary rat? I, loser"
"Solomon O['] Mo['] Los"
"Sr. Edd Adders"
"Suede Deus"
"'Tabu' Kubat"
"Tacoma Mo Cat"
"Tad, Effed-At"
"Tannin['] Nat"
"Tar Prat"
"Taxa['] T"
"'Teepee' Peet"
"Tim O['] Vomit"
"Toilless Elliot"
"Tony H. Why-Not"
"'Tragedy' DeGart"
"'Treble' Delbert"
"'Trebles' Elbert"
"Trekker T"
"Trev Re-Pervert"
"Tru Burt"
"Ur-Dru"
"'Vests' Ev"
"Video Ed IV"
"'Wah' Shaw"
"Walla Walla W" [this is a personal favorite]
"Wazza W"
"Weewee W"
"Well Lew"
"Wm. BMW"
"Wolf Low"
"Yellow Swolley"
"Yelper Epley"
"'Yelps' Aspley"
"Yob Ops Po['] Boy"
"'Zepo' Lopez"

table of Rob droning [xxrob]
randtxt
"Am ham-handed? Nah, Ma. Hm, a..."
"Analyticity? Lana!"
"BA? Fab!"
"Bah! Ahab?!"
"Boone?! Noob!"
"Boris is I, ROB?!"
"Boy, BYOB!"
"Can Gignac!"
"Cigar? Tragic!"
"Cito?! Idiotic!"
"Cull Luc!"
"D-N-D! D-N-D!"
"D: race card!"
"Dah! Chad?!"
"De-QED!"
"Degauss? Assuaged!"
"Del fled!"
"Dev! O, Loved!"
"Dias Said..."
"Disgusts, ug, Sid!"
"Draco?! Card."
"E-dude?!"
"Edit-IDE?"
"Enos's one..."
"EOF, Foe!"
"Erase Cesare!"
"Ev? Reserve!"
"Eva Gave..."
"Face Decaf?!"
"Field Leif!"
"Flag Alf!"
"Flay Alf!"
"Fran? Snarf!"
"Geniuses['] UI? Neg!"
"GI? Pig!"
"Gnome? Mo['] N. G.!"
"Gord? A cad? Rog?!"
"Grad? Arg!"
"Graf-arg! Graf-arg!"
"H's Awash!"
"H/t Emeth!"
"Habit, I? Bah!"
"Hank? Nah."
"Hans? Nah."
"Haw! ... Ah?"
"He's ... eh."
"Hemp? Meh!"
"Hodad! Oh!"
"Hoses! Oh!"
"Howard? Raw, oh!"
"Hush, suh[']!"
"I: CMD MC, I!"
"Idea-ed, I!"
"If I wifi..."
"Ion?! Oi!"
"Iso Si!"
"J****, EJ!"
"Jonah: an OJ?"
"Last?! Sal?!"
"Lie, Neil!"
"Lo, googol!"
"Lo! Nitinol!"
"Loaded AOL?!"
"Lonely? Xylenol!"
"Mac, see? Scam!"
"Mahalo! La! ... Ham."
"Mail Lilliam..."
"Marc, Scram!"
"MIT?! So STIM!"
"Mod Less Seldom!"
"Mod?! ODOM?!"
"More ROM!"
"Morons! No ROM!"
"Nae Dean!"
"Nay, cyan!"
"Nets? Ten!"
"Nip Pippin..."
"No! Brace me, carbon!"
"No! Ebb, eon!"
"No ROMs, moron!"
"No Swahili? Haw, son!"
"Norm? Ron?"
"Nos to Dotson!"
"Not To Cotton..."
"NRA: warn!"
"Nuh-uh! Un..." [okdup]
"Ope['], epo!"
"Optimum, it? Po[']!"
"Or Camp? Macro!"
"Or Prefer Pro!"
"Params Is Ma Rap!"
"Parthenon, eh? Trap!"
"Phat? STAHP!"
"Piece IP?!"
"Po['] him! IHOP?!"
"Pondered: nOP."
"Posts-op? POST, sop!"
"Posy sysop!"
"Prove VORP!"
"Provided, I: VORP!"
"Puh, Same Mashup!"
"Put Eli?! Let up!"
"Rap? Bust! Subpar!"
"Reb! UBER!"
"Red lo-fi folder?!"
"Red nerd, render!"
"Redo-coder! Redo-coder!"
"Ren? Woe Owner!"
"Ren? Wordy Drowner!"
"Rep, mate! Tamper!"
"Resume [']m, user!"
"Retract Carter!"
"Rodney: end, or...?"
"Ruses? Ur..."
"[']S BS!!!!!"
"S. P.? Mumps!"
"Sad! No Hondas!"
"Sam? Edemas!"
"Sam? Enemas?!"
"Sam?! Mommas!"
"Segard? Rages!"
"SETI cites."
"SETI sites!"
"Si? Dis!" [okdup]
"Signing is..."
"Sir, O! Boris?!"
"Site? [']Tis!"
"So Ill, iOS!"
"So-pert repos!"
"Sod U! Kudos?!"
"Spidered IPs?!"
"Steve vets..."
"Sun obsesses? Bonus!"
"SuSe? J****!"
"Sy? A ways!"
"Taran? A rat!"
"Tim? O, vomit!" [okdup]
"[']Tis. Suss it!"
"To ban a bot..."
"To rot! To rot!"
"Toby?! Bot!"
"Too rococo root."
"TP? Apt!"
"Trope?! Deport!"
"Up, CPU!"
"Vernon, REV!"
"X on Knox!"
"Y-array?!"
"Y b Bobby?"
"Yah! Shay?!"
"Yale? Delay!"
"'Yanno' Annoys!"
"Yo, Roy!"
"YT? Inanity!"

table of sci pics subjects [xxsci] [xxpics] [xxcorp] [xxlab]
randtxt
"an enol alone"
"h/t ethics"
"a lab ace cabal"
"loner enol"
"loser cresol"
"nitro-cortin"
"nival flavin"
"no bracy carbon"
"no endewed neon"
"no graded argon"
"no igniting ion"
"no next xenon"
"noises ion"
"none xenon"
"nor igniting iron"
"or tiny nitro"
"set agile ligates"
"set-aloft folates"
"setulose solutes"
"sly canikin acyls"
"sly mad amyls"
"sly mass amyls"
"sly rad aryls"
"so-real aeros"
"sorting nitros"

table of singstuff [xxsing]
randtxt
"Ode? Redo!"
"Rock! Cor!"
"Tone? Not!"
"Tune nut!"
"Yodeled? Oy!"

table of snooty toon ads [xxtoon] [xxads] [xxfood] [xxeat]
randtxt
"Ay, a papaya"
"dessert stressed"
"Fee Beef"
"Food ... oof"
"gone-nog"
"Guava?! Ug"
"Gum? Ug"
"Hep-met tempeh"
"I/O Poi"
"liver, evil"
"Mahi Ham"
"mass assam"
"no dull udon"
"no revile-liver on"
"nom la salmon"
"oil olio"
"risotto, Sir"
"salad (alas)"
"salami, dim, alas"
"Seer-Up Purees"
"set-tall lattes"
"soya-mayos"
"strati tarts"
"Sup Opus"

table of swearstuff [xxswear] [xxcuss]
randtxt
"Bad? A dab!"
"Dammit, I'm mad!"
"Dark. Rad!"
"Delivery: Reviled!"
"Dood! DOOD!"
"Fa, oaf!"
"Grunt'n! Urg!"
"Guff! Ug!"
"Harp! Rah!"
"Hell, eh?"
"Hoot! Ooh!"
"Hot! Oh!"
"Iyiyi!"
"Kook!"
"Not on!"
"Oo, coo-coo!"
"Oo, doo-doo!"
"Oo, poo!"
"Oo! Too..."
"Pah, chap!"
"Red? No wonder!"
"Redder... redder..."
"Rep me, temper!"
"Revile?! Deliver!"
"(R)rude! Dur(r)!"
"Speel? Bleeps."
"Tact, cat!"
"Tat, tat, tat!"
"Tic? Illicit."
"Tit!"
"Tons-o-Snot!"
"Too coocoo, coot!"
"Tut!"
"Wack caw!"
"Ward raw..."
"Well, EW!"
"Y'booby!"
"Y'kooky?"
"Yap? Ay!" [okdup]

table of undoings [xxundo]
randtxt
"Ay, CYA."
"Delete-Led!"
"Did. Error? Redid."
"Did. [']Nuff? Undid."
"Dur. Crud."
"Eff a gaffe."
"Ho! ... D'oh!"
"It: Revert, I!"
"Modern Redo [']M."
"Nixin[']..."
"Not. Revert. On!"
"Or, Perp, REPRO!"
"Pah, simp! Mishap!"
"Pre-derp..."
"Re-deed [']er!" [okdup]
"Recall acer!"
"Redact, cad! Er..."
"Redid [']er."
"Redo'd [']er."
"Renege'n [']er!" [okdup]
"Ret. All later."
"A ret['], e-cetera."
"Ret['], sister!"
"Returnin['] rut, er..."
"Sod [']er! Redos!"
"Time: remit."
"Tinker, tinker ... reknit, reknit!"
"X! I fix!"

table of trashy art [xxart]
randtxt
"AM Enema"
"Amen, Enema"
"Anal Alana"
"Burt, Rub"
"Den O['] BONED"
"A Devotee to Veda"
"Didi Did"
"Dior Droid"
"Diva Vid"
"Emu Love Volume"
"[']Ere Peewee, Pere"
"Gelded Leg"
"Gigolo Gig"
"Lap, Opal"
"Leer Reel"
"Liane, Re-Nail"
"Minimum in [']Im"
"Ms. A Groan an['] a Orgasm" [capsok]
"Much ***" [ignore]
"Nae, Wanna Wean"
"Nail Elian"
"Nail Lillian"
"Odette, Do"
"On Nude? Dunno"
"Onan, O"
"One Pipe? No"
"Orgasms-a-Gro"
"Pee Jeep"
"Poon Snoop"
"Re-Film, Lifer"
"Re-Mate, Tamer"
"Red, Well, Lewder"
"[']S BOOBS" [capsok]
"[']S SENSUOUSNESS" [capsok]
"Sado-Codas"
"Sameness Enemas"
"Sedu-Dudes"
"Servile Livres"
"Set Indeed Nites"
"Sex Axes"
"Sex, Eff Exes"
"Sex-I-Fixes"
"Sex O['] Foxes"
"Sexes"
"Sez Tidy Ditzes"
"So Rec Eros"
"Solo Gigolos"
"A Sordid Rosa"
"Sorell, Eros"
"Sun Eve Venus"
"[']Sup, Mack Campus"
"Tape Pat"
"To Prefer Pot"
"Twats Tawt"
"Vamp-M Av"
"A Vow, Ova[']"
"Vuln-Luv"
"Warm, Raw"
"Womb Mow"
"Y'd Daddy"
"Y's Sassy"
"Y's Sissy"

table of university primary targets [xxu1] [xxuu1] [xxdoc]
randtxt
"B. Reverb"
"Chanah C"
"Dr. A. Card"
"Dr. A. Fafard"
"Dr. A. Gard"
"Dr. A. Ward"
"Dr. A. Wooward"
"Dr. Aagaard"
"Dr. Allard"
"Dr. Aza Hazard"
"Dr. E. Herd"
"Dr. Ellerd"
"Dr. I. Bird"
"Dr. O. Ford"
"Dr. O. Lord"
"Dr. Offord"
"Dr. Ord"
"Dr. U. Curd"
"Dr. U. Hurd"
"Dr. Y. Byrd"
"Mr. Y. Wyrm"

table of university secondary targets [xxu2] [xxuu2]
randtxt
"A. Doda"
"A. Duda"
"A. Gallaga"
"A. Kamaka"
"A. Loyola"
"A. Mellema" [okdup]
"A. Rivira"
"A. Takata"
"A. Tata"
"B. Babb"
"B. Bibb"
"C. Ilic"
"Cremer, C"
"D. Azad"
"D. Dodd"
"D. LeFeld"
"Dellavalle, D"
"E. Cacace"
"E. Dulude"
"E. Fyfe"
"E. Gage"
"E. Gammage"
"E. Irie"
"E. Noone"
"E. Pope"
"E. Revere"
"E. Senese"
"E. Tate" [how the hell did I miss this one at first? RIP, Emory Tate.]
"F. Assaf"
"G. Nang"
"G. Ng"
"G. Nilling"
"Greer, G"
"H. Allah"
"H. Cech"
"H. Ninh"
"H. Sakash"
"H. Sash"
"H. Toth"
"I. Asai"
"I. Li"
"I. Nani"
"I. Natani"
"I. Yi"
"K. Cammack"
"K. Carrack"
"K. Coppock"
"K. Sisk"
"K. Wowk"
"Kniffin, K"
"Kreger, K"
"Kremer K"
"L. Appal"
"L. Atal"
"L. Emmel"
"L. Ettel"
"L. Exel"
"L. Lawall"
"L. Levell"
"Lippi, L"
"M. Hahm"
"M. Odom"
"N. Alan"
"N. Allan"
"N. Annan"
"N. Eben"
"N. Eggen"
"N. Ellen"
"N. Essen"
"N. Ewen"
"N. Hahn"
"O. Cavaco"
"O. Ilalio"
"O. Kiko"
"O. Nagano"
"O. Nakano" [okdup]
"P. Popp"
"Prekker, P"
"R. Agar"
"R. Eber"
"R. Egger"
"R. Ekker"
"R. Emmer"
"R. Etter"
"S. Abbas"
"S. Edes"
"S. Innis"
"S. Newens"
"S. Pillips"
"S. Reyers"
"S. Teets"
"S. Tibbits"
"Sr. Ayars"
"Sr. Ebbers"
"Sr. Eggers"
"Sr. Ellers"
"Sr. Etters"
"Sr. Evers"
"Sr. Ewers"
"T. Laxalt"
"T. Rebert"
"T. Tennett"
"T. Tott"
"Treger, T"
"U. Arau"
"U. Babu"
"U. Hu"
"U. Kaku"
"Valela, V"
"X. Essex"
"Y. Baraby"
"Y. Dody"
"Y. Eley"
"Y. Rury"
"Z. Nanz"
"Z. Oz"
"Z. Teetz"

table of waittxt [xxwait] [xxzs]
randtxt
"Camp, mac!"
"Deed, deed, deed!"
"Def['] faffed!"
"Do?! God!"
"Do, STAT, sod!"
"Don't nod!"
"Elapses. Pale."
"ETA, Mate?"
"Gall! Lag!"
"GO, dog!"
"Keep up, eek!"
"La! Rut: a natural!"
"A lag gala!"
"Mull! Um..."
"Nix ALERT. Relaxin[']!"
"No gig on?"
"No, it can! Action!"
"Now? On!"
"Pal...flap!"
"Panic? I nap!"
"Pas ASAP!"
"Porer-op!"
"Rests? Er..."
"A rests era!"
"Resume, muser!" [okdup]
"Rev, o rover!"
"Sod dos."
"Stare? Rats!"
"Stir! It's..."
"Task: SAT!"
"Truce, curt."
"Wait! I ... aw ..."
"Wandered? Naw."
"We nap anew."
"Won't, Now."
"Y-go-logy?!"
"Y'revery!" [ignore]
"Yon! Oy!"
"Zen? E-Z!"

table of wordy drow laments [xxdrow] [xxwordy]
randtxt
"Bardo...drab!"
"Deity...tied!"
"Die, id!"
"Direr id!" [okdup]
"Ebb? Be!"
"Eh, tithe!"
"Eidolon: No? Lo, Die!"
"Foul, u Of..."
"Genii? Neg!"
"Guts, TUG!"
"Id-egged, I!"
"Imp, M I?"
"In, Imp, Mini."
"Lama? Mal!"
"Lasso dossal!"
"Lie? De'il!"
"Mass? A.M."
"Nag a Pagan!"
"No Sin is On!"
"No sin: us, unison!"
"Nom, Rest, Sermon."
"Onan? A no!"
"Possesses? Sop!"
"Sad as..."
"Sin, I? Finis!"
"Sob! Mild Limbos!"
"Sog, Ebb, Egos!"
"Sue Zeus?!"
"Sun: I, MINUS!"
"To Rot."
"Want? Naw!"
"Worth: trow."

table of yessies [xxyes]
randtxt
"Ee! Wowee!"
"Ha, Yah."
"Heheh."
"Hoooooooh!"
"Hosannas, Oh!"
"Laud-ual!"
"Mirth? Trim!"
"Mmhmm!"
"Nod on!"
"Ooh, aye! Yahoo!"
"Pep!"
"Pip, pip!"
"Plus? Ulp." [okdup]
"Too Wanna-Woot!"
"Too woot!"
"Wahoo! Haw!"
"Wooooooow!"
"Yay!"
"Zest's E-Z!"

table of yall people [xxyall]
randtxt
"Ami Lusk-Sulima"
"Anna Hamm-Mahanna"
"Art Salz-Lastra"
"Asa Winn-Iwasa"
"Avila, Val-Iva"
"Bagan, Alana-Gab"
"Bedard, Isidra Deb"
"Bee Bahr-Habeeb"
"Borrello-Zoller, Rob"
"Breanne-Jenna Erb"
"Camden, Ed Mac"
"Camino, Toni Mac"
"Cassisse, Jess Issac"
"Celani, Allain-Alec"
"Cirelli, Bill-Eric"
"Dee Tsu-Steed"
"Dettra, Bart-Ted"
"Diersen, Ines Reid"
"Drucilla Valli-Curd"
"Duane Duden-Aud"
"Enid Revelle-Verdine"
"Erin Amaya-Manire"
"Etter, Eugene Guerette"
"Evelina Kakani-Leve"
"Ewa Hsu-Shawe"
"Fielder, Ed Leif"
"Flahaven, Eva Half"
"Flatter, Everett Alf"
"Flo Dann-Adolf"
"Florrie Keir-Rolf"
"Gay Adamo-Madayag"
"Gia Raciti-Caraig"
"Gil Hobb-Bohlig"
"Gil Hupp-Uhlig"
"Grubel, Dierdre Idleburg"
"Hal-Luc Ullah"
"Hana Vaka-Kavanah"
"Hanna Vass-Savannah"
"Helena Sayasane-Leh"
"Herman Dednam-Reh"
"Ilene Toten-Eli"
"Ines Homa-Mohseni"
"Ira Touhy-Huotari"
"Iris Epp-Pesiri"
"Isa Medici-Demasi"
"Jamila Bali-Maj"
"Jane Suhr-Husenaj"
"Jarrett Otter-Raj"
"Jed Arnesen-Radej"
"Jo Kopf-Pokoj"
"Kay Mohr-Homyak"
"Kinnaird, Adrian Nik"
"Kint, Alba Blatnik"
"Krishna Danh-Sirk"
"Kusner, Oren Suk"
"Latanya Day-Natal"
"Lev Ramm-Marvel"
"Liz Abaja-Bazil"
"Lorretta Watt-Errol"
"Lu-Sara Rasul"
"Martina-Jani Tram"
"Mirna Holohan-Rim"
"Morgan-Irina Grom"
"Mulligan, Irina Gillum"
"Myles Tse-Lym"
"Nilsen, Ines Lin"
"Nora Habib-Aharon"
"Norbert Sastre-Bron"
"Novak, Siska Von"
"Novielli, Cecille Ivon"
"Oksen, Emory Romenesko"
"Oren Amici-Manero"
"Orie, Tami Mateiro"
"Orr, Eugene Guerro"
"Oz, Nolan Alonzo"
"Payne, Ben Yap"
"Peter Abare-Tep"
"Petra Salasar-Tep"
"Pigram, Omar Gip"
"Pinelli, Cecille Nip"
"Rey Arts-Strayer"
"Riemann, Ayanna Meir"
"Rosaria Kai-Rasor"
"Russell Alles-Sur"
"Ruz, Ami Mazur"
"Sue Tamara-Mateus"
"Sugar, Ira Gus"
"Sumiko Bok-Imus"
"Swett, Amee Mattews"
"Sydney Yen-Dys"
"Trevor DePedro-Vert"
"Trotter, Brett Ort"
"Tsu, Colette Locust"
"Tur, Kim Mikrut"
"Ty O'Hara-Hoyt"
"Uballe, Nell Abu"
"Ude, Isa Asiedu"
"Ugarte, Petra Gu"
"Ullo, Sol Lu"
"Uyeda, Jade Yu"
"Velma Eleam-Lev"
"Venus Hsu-Nev"
"Vergari, Kira Grev"
"Vilanova, Lavona Liv"
"Vizard, Isidra Ziv"
"Waltner, Brent Law"
"Welder, Fred Lew"
"Wolford, Isidro Flow"
"Wolfram, Omar Flow"
"Wolk, Ruby Burklow"
"Yarnell, Allen Ray"
"Yolande-Edna Loy"
"Yorton, Amano Troy"
"Yuri Adair-Uy"
"Yvonne Toten-Novy"

table of yuge baits [xxbait]
randtxt
"Avoided I? Ova[']!"
"Boo! Goob!"
"BOO, NOOB!"
"Departee traped!"
"Dim, I! Timid!"
"Evar brave!"
"EY, BYE!"
"Fie! If..."
"Foot! Oof!"
"Gasp! Sag!"
"Go, Drawn War-Dog!"
"GOP: O. G.!"
"K, ****!"
"Legs, gel!"
"LOW AWOL!"
"[']N u Re-run!"
"[']N u Run!"
"Nary ran!"
"No! Left, felon!"
"Oft GTFO!"
"Ole! Lo!"
"PEER?! CREEP!"
"Pivot, O, VIP!"
"Poof! Oop!"
"Res BS'er!"
"Sir afar is!"
"So-Shh SOS!"
"Sullage! Gallus!"
"Timid? I'm it!"
"Tire! Me, merit!"
"TRAWL, WART!"
"Trot?! A Tort!"
"Warded, raw..."
"Y'lily!"
"Yes, truce! Curtsey!"

table of yuge battle cries [xxyuge] [xxguy]
randtxt
"A-Lago gala!"
"A-lists? I? La!"
"Ai! [']Til I, Militia!"
"Alibi! La!"
"As to TSA..."
"At a Hata[']!"
"Be Reb!"
"Big, I B!"
"Bilk-Lib!"
"BO! Yob!"
"Bosh, SOB!"
"Deific?! Nancified!"
"Deport [']r! Op-ed!"
"Dig Id!"
"Drat, O Dotard!"
"E.U.?! Sue!"
"El bannable!"
"Ere me, MERE!"
"EVAR crave!"
"Ey, dye?!"
"Faded AF!"
"Fib, If..."
"Fop of..."
"A game?! MAGA!"
"Gendered? Neg!"
"Gent? Neg!"
"Gibe! Big!"
"God, pale lapdog!"
"Grain, I? Arg..."
"Grass?! Arg!"
"Ha, Pah!"
"Hah, solo shah!"
"Haiti? Ah!"
"Heft, Feh!"
"Heists, I?!?! Eh..."
"Hog, oh!"
"Hoo! Preyer? Pooh!"
"Hoops? Pooh!"
"Huge! Guh!"
"I B FBI!"
"I! Oi!!!"
"I'm Too ... TMI!"
"I'z a ****!"
"Imam, I!"
"Iou?! OI!"
"Iz no Ponzi!"
"KJU? J/k!"
"Laff?! Offal!"
"Let Nix Intel!"
"Mad-Eyed, Am!"
"Maga'M!"
"Main, I am!"
"Me, DEM?!" [okdup]
"Me: FWIW, F em!"
"ME!!!! Haw. Ahem."
"Me, nem[']!"
"Me: sees [']em!"
"Misdeeds? I'm ..."
"MLM! MLM! MLM!"
"Mod? Naff: Fandom."
"Moobs: BOOM!"
"MSM?! MSM!"
"[']N I WIN!"
"Nah, prop orphan!"
"Name: HE-MAN!"
"NASA's an..."
"Nem O['] women!"
"Nil Appalin[']!"
"No cede, con!"
"No con, no con!"
"No: I, Zion!"
"No Naff Anon!"
"No, old loon!"
"Nor a Baron!" [okdup]
"Null [']un!"
"O, rehab a hero!"
"Odd-*** Saddo!" [ignore]
"Oh, BHO!"
"OK! Cis! Sicko!"
"On U! Y U no..."
"One Garage? No!"
"Ooh, chaff! Ahchoo!"
"Ooh...shoo!"
"Opinin[']: I, Po[']!"
"Pal! Clap!"
"Pal, rub burlap!"
"A papa! A papa!"
"Perform'r of REP!"
"Pilf'r! Flip!"
"PR, usurp!"
"Rail, Liar!"
"Re-sold LOSER!"
"ROB ALL LABOR!"
"Rug?! Ur..."
"See pure rupees!"
"See purses, rupees!"
"See weepy peewees!"
"Set aha-hates!"
"Sir, buh! Hubris!"
"So, Like Kilos?"
"So obese? Boos!"
"So?! Obsesses?! Boos?!"
"So, PoS!"
"So Rued, Euros."
"So-sos!"
"Sod! No Condos?"
"Sorer, o toreros!"
"Soros! Soros!"
"Spoil, I: Ops!"
"Sue Me?! Us?!"
"Surviv'r: US!"
"Taft?! FAT!"
"Tar comedy?! Democrat!"
"Tariff? I? Rat!"
"Tases at..."
"Tawt?! WAT?!"
"Tiara it!"
"Titan, AT IT!"
"To Old Loot!"
"Torah? Ha! Rot!"
"Tuck, Cut..."
"Wane? Naw!"
"Wobley Elbow!"
"Y M Enemy?"
"Y'r Dry!"
"Ye no-money!" [okdup]
"Yer PREY!"
"Yoink'n, I! Oy!"
"You! Oy!"

Ailihphilia Tables ends here.

---- DOCUMENTATION ----
